function SetTplCookie(name, value) {
  SetCookie('starry[' + name + ']', value, 3600 * 24 * 7 * 30, '/');
}

function GetTplCookie(name) { return GetCookie('starry[' + name + ']'); }

window.onload = AddChainFuncTo(window.onload, function () {
  $each(onLoad, function (func) { func(); })
});
window.onresize = AddChainFuncTo(window.onresize, UpdWindowSize);

  var onLoad = [];

onLoad.push(UpdWindowSize);
function UpdWindowSize() {
  var top = parseInt( $style('rightBorder', 'top') ) + 150;
  $hide('rightBorder');
  $style('rightBorder', 'height', Math.round(DocumentHeight() - top) + 'px');
  $show('rightBorder');

  $style('toTop', 'marginTop', Math.round(WindowHeight() / 2 - 40) + 'px');
  $style('toBottom', 'marginTop', Math.round(WindowHeight() / 2 + 20) + 'px');
  $style('favs', 'marginTop', Math.round(WindowHeight() / 2 - 10) + 'px');
}

  var tocState = 'hidden';
  var tocSpeed = 250;

function FolderIn(folder) {
  if (tocState != 'hidden') { return; }
  tocState = 'showing';

  var tocLeft = Math.round( parseInt( $style(folder, 'left') ) - folder.FullWidth
                            + WidthOf(folder) / 2 );

  var effects = [{prop: 'opacity', element: folder.ToC, maxDuration: tocSpeed, accel: true},
                 {prop: 'width', element: folder.ToC, maxDuration: tocSpeed, accel: true,
                  targetValue: folder.FullWidth},
                 {prop: 'left', element: folder.ToC, maxDuration: tocSpeed, accel: true,
                  targetValue: tocLeft, reverse: true,
                  onDone: function () { tocState = 'shown'; } }];

  $opacity(folder.ToC, 0);
  WidthOf(folder.ToC, 0);
  $style(folder.ToC, 'left', tocLeft + folder.FullWidth + 'px');

  $style(folder.ToC, 'top', folder.Top + GetScrollY() + 'px');
  $show(folder.ToC);
  Slide(effects);
}

function FolderOut(folder) {
  if (tocState != 'shown') { return; }
  tocState = 'hiding';

  var options = {maxDuration: tocSpeed / 2, accel: true,
                 reverse: true, onDone: function () { tocState = 'hidden'; } };

  SlideAs('opacity hideWhenDone', folder.ToC, options);
}

function HookToC(toc) {
  toc.className = 'toc-js';

  if (DebugAssert( fieldset = FindChildOf(toc, 'fieldset', null) )) {
    // fixed width so it won't wrap when containing DIV is collapsed.
    WidthOf(fieldset, WidthOf(fieldset) - 40);
  }

  var folder = $('tocFolder');
      folder.ToC = toc;
      folder.FullWidth = WidthOf(toc);
      folder.Top = parseInt( $style(toc, 'top') );

  var mouse = new MouseEvents(folder);
                  mouse.AlsoHook(toc);
                  mouse.AlsoHook('rightBorder');
      mouse.onIn.call = function () { FolderIn(folder); }
      mouse.onIn.delay = 100;
      mouse.onOut.call = function () { FolderOut(folder); }
      mouse.onOut.delay = 500;

  $hide(toc);
  $show('tocFolder');
}

function SetupMenu() {
  $('fullWidth').onclick = function () {
    var wr = $('outerWrapper');
    if (wr.IsWide) {
      $style('outerWrapper', 'width', wr.OldWidth);
    } else {
      if (!isset(wr.OldWidth)) { wr.OldWidth = WidthOf(wr) + 'px'; }
      $style('outerWrapper', 'width', '95%');
    }

    UpdWindowSize();

    wr.IsWide = !wr.IsWide;
    ModifyClassNameOf('outerWrapper', 'wide', wr.IsWide);

    SetTplCookie('wide', wr.IsWide ? '1' : '0');
    $show('resetSettings');
  }

  $('fontInc').onclick = function () { IncFontSize(+1); }
  $('fontDec').onclick = function () { IncFontSize(-1); }

  $('resetSettings').onclick = function () {
    if (GetTplCookie('wide') == '1') { $('fullWidth').onclick(); }
    SetTplCookie('size', null);
    FontSize(12);

    $hide(this);
  }
}

  function FontSize(newSize) {
    if (IsNum(newSize)) {
      SetTplCookie('size', newSize);
      $style('outerWrapper', 'fontSize', newSize + 'px');
      if (newSize != 12) { $show('resetSettings'); }
    } else {
      return parseInt( $style('outerWrapper', 'fontSize') );
    }
  }

  function IncFontSize(delta) { FontSize(FontSize() + delta); }

// must be ran before right border is adjusted.
onLoad.unshift(function () {
  if (GetTplCookie('wide') == '1') { $('fullWidth').onclick(); }
  FontSize( GetTplCookie('size') );
});


function ClearFavs() { SetFavs( [] ); }

function SetFavs(list) {
  SetTplCookie('favs', JSON.stringify(list));
  UpdateFavList();
}

function GetFavs() {
  var result = [];
  try {
    var list = JSON.parse( GetTplCookie('favs') );
  } catch (e) {
    var list = [];
  }

    if (IsNonEmptyArray(list)) {
      for (var i in list) {
        var fav = list[i];
        if (isset(fav.url) && isset(fav.title) && isset(fav.date)) {
          result.push(fav);
        }
      }
    }

  return result;
}

function AddFav(url, title, date) {
    if (!url) { url = location.href.split('#')[0]; }
    if (!title) { title = document.title.split(/«/)[0].replace(/\s+$/, ''); }
    if (!date) { date = Date.now(); }

  var favs = GetFavs();
  var remove;

    for (var i in favs) {
      if (favs[i].url == url) {
        remove = i;
        break;
      }
    }

  if (remove) {
    favs.splice(remove, 1);
  } else {
    favs.push( {url: url, title: title, date: date} );
  }

  SetFavs(favs);
}

function UpdateFavList() {
    var months = ['I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'XIX', 'X', 'XI', 'XII'];

  var parent = $('favList');
  RemoveChildrenOf(parent);

  var favs = GetFavs();

  if (IsNonEmptyArray(favs)) {
    $each(favs, function (fav) {
      var li = document.createElement('li');

      if (location.href.split('#')[0] == fav.url) {
        var link = document.createElement('strong');
      } else {
        var link = document.createElement('a');
            link.href = fav.url;
      }

      var now = new Date();
      link.title = now.getDate() + '.' + months[ now.getMonth() ];
      link.innerHTML = fav.title;

      li.appendChild(link);
      parent.appendChild(li)
    });
  } else {
    var li = document.createElement('li');
        li.innerHTML = window.Strings['fav empty'];
        li.className = 'empty';
    parent.appendChild(li)
  }
}
